unit Site.Navbar;

interface

procedure InjectNavbar;

implementation

uses
  JS, Web;

const
  NavbarHtml =
    '<div class="em-navbar-wrap">' +
    '  <nav class="navbar navbar-expand-lg navbar-dark bg-dark fixed-top shadow py-1 py-lg-2">' +
    '    <div class="container-fluid container-main">' +
    '      <a class="navbar-brand em-brand me-auto" href="#FHome">' +
    '        <img src="images/EM_Logo_2c66a0.png" alt="EM_Logo"">' +
    '      </a>' +
    '      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav"' +
    '        aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">' +
    '        <span class="navbar-toggler-icon"></span>' +
    '      </button>' +
    '      <div class="collapse navbar-collapse" id="navbarNav">' +
    '        <ul class="navbar-nav ms-auto gap-lg-3">' +
    '          <li class="nav-item"><a class="nav-link" href="#FHome">Home</a></li>' +
    '          <li class="nav-item"><a class="nav-link" href="#FAboutUs">About Us</a></li>' +
    '          <li class="nav-item dropdown">' +
    '            <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">What We Do</a>' +
    '            <ul class="dropdown-menu">' +
    '              <li><a class="dropdown-item" href="#FPublicSafety">Public Safety Software</a></li>' +
    '              <li><a class="dropdown-item" href="#FRecordsManagement">Records Management Notification</a></li>' +
    '              <li><a class="dropdown-item" href="#FCustomSoftware">Custom Software</a></li>' +
    '            </ul>' +
    '          </li>' +
    '          <li class="nav-item"><a class="nav-link" href="#FContactUs">Contact Us</a></li>' +
    '        </ul>' +
    '      </div>' +
    '    </div>' +
    '  </nav>' +
    '</div>';

procedure InjectNavbar;
var
  el: TJSHTMLElement;
begin
  el := TJSHTMLElement(document.getElementById('site_nav'));
  if Assigned(el) then
    el.innerHTML := NavbarHtml;
end;

end.
