unit View.ContactUs;

interface

uses
  System.SysUtils, System.Classes, WEBLib.Graphics, WEBLib.Forms, Vcl.StdCtrls,
  WEBLib.StdCtrls, Vcl.Controls, WEBLib.Dialogs, Vcl.Imaging.pngimage,
  WEBLib.ExtCtrls, WEBLib.Controls, Web, JS, WEBLib.Menus, WEBLib.WebCtrls,
  XData.Web.Connection, XData.Web.Client, Data.DB, Utils,
  XData.Web.JsonDataset, XData.Web.Dataset, Vcl.Grids,
  WEBLib.DBCtrls, WEBLib.DB, WEBLib.Grids, WEBLib.CDS, WEBLib.REST,
  WEBLib.WebTools, System.NetEncoding, WebLib.RegularExpressions,
  WEBLib.Toast, XData.Web.Request, XData.Web.Response;

type
  TFContactUs = class(TWebForm)
    edtName: TWebEdit;
    edtEmail: TWebEdit;
    edtSubject: TWebEdit;
    memoMessage: TWebMemo;
    btnSubmit: TWebButton;
    xdwcEmail: TXDataWebClient;
    procedure btnSubmitClick(Sender: TObject);
    procedure WebFormShow(Sender: TObject);
    procedure xdwcEmailError(Error: TXDataClientError);
  private
    { Private declarations }
    function IsInputValid: Boolean;
    function IsEmailValid(const email: String): Boolean;
    [async] procedure SendEmail;

  public
    procedure NavScrollSizing;
  end;

var
  FContactUs: TFContactUs;

implementation

{$R *.dfm}

uses
  ConnectionModule,
  View.Home,
  View.PublicSafety,
  View.RecordsManagement,
  View.CustomSoftware,
  Site.Navbar,
  Site.Footer,
  View.AboutUs;

procedure TFContactUs.WebFormShow(Sender: TObject);
begin
  Application.ThemeColor := clTMSWEB;
  InjectNavbar;
  InjectFooter;
  SetFooterVersion('ver - ' + TDMConnection.clientVersion);
  NavScrollSizing;
end;

procedure TFContactUs.xdwcEmailError(Error: TXDataClientError);
begin
  ShowNotificationModal('Error when attempting to send: ' + error.ErrorMessage);
end;

procedure TFContactUs.NavScrollSizing;
begin
  asm
    window.addEventListener('scroll', function() {
      var navbar = document.querySelector('.em-navbar-wrap .navbar');
      var logo = document.querySelector('.em-brand img');
      var scrollDistance = 50;

      if (window.scrollY > scrollDistance) {
        navbar.classList.add('scrolled');
        logo.classList.add('scrolled-logo');
      } else {
        navbar.classList.remove('scrolled');
        logo.classList.remove('scrolled-logo');
      }
    });
  end;
end;

function TFContactUs.IsEmailValid(const email: string): Boolean;
const
  pattern = '^[^\s@]+@[^\s@]+\.[^\s@]+$';
begin
  Result := TRegEx.IsMatch(email.Trim, pattern);
end;

function TFContactUs.IsInputValid: Boolean;
var
  nameOk: Boolean;
  emailOk: Boolean;
  subjectOk: Boolean;
  messageOk: Boolean;
begin
  nameOk := edtName.Text.Trim <> '';
  emailOk := IsEmailValid(edtEmail.Text);
  subjectOk := edtSubject.Text.Trim <> '';
  messageOk := memoMessage.Text.Trim <> '';

  Result := nameOk and emailOk and subjectOk and messageOk;
end;

procedure TFContactUs.btnSubmitClick(Sender: TObject);
begin
  if not IsInputValid then
  begin
    ShowNotificationModal('Please complete all fields and ensure the email address is valid.');
    Exit;
  end;
  if not DMConnection.ApiConnection.Connected then
  begin
    DMConnection.ApiConnection.Open(
      procedure
      begin
        SendEmail;
      end);
    Exit;
  end;

  SendEmail;
end;

procedure TFContactUs.SendEmail;
begin
  xdwcEmail.RawInvoke('IApiService.SendEmail',
    [edtName.Text, edtEmail.Text, edtSubject.Text, memoMessage.Text],
    procedure(response: TXDataClientResponse)
    begin
      ShowNotificationModal('Your message has been sent successfully. Please check your email for a response in the next 48 hours.');

      edtName.Text := '';
      edtEmail.Text := '';
      edtSubject.Text := '';
      memoMessage.Text := '';
    end);
end;



initialization
  RegisterClass(TFContactUs);

end.
