unit View.CustomSoftware;

interface

uses
  System.SysUtils, System.Classes, WEBLib.Graphics, WEBLib.Forms, Vcl.StdCtrls,
  WEBLib.StdCtrls, Vcl.Controls, WEBLib.Dialogs, Vcl.Imaging.pngimage,
  WEBLib.ExtCtrls, WEBLib.Controls, Web, JS, WEBLib.Menus, WEBLib.WebCtrls;

type
  TFCustomSoftware = class(TWebForm)
    [async]
    procedure WebFormShow(Sender: TObject);
  private
    { Private declarations }
  public
    procedure NavScrollSizing;
  end;

var
  FCustomSoftware: TFCustomSoftware;

implementation

{$R *.dfm}

uses
View.AboutUs,
View.ContactUs,
View.Home,
View.PublicSafety,
Site.Navbar,
Site.Footer,
ConnectionModule,
View.RecordsManagement;

procedure TFCustomSoftware.WebFormShow(Sender: TObject);
begin
  Application.ThemeColor := clTMSWEB;
  InjectNavbar;
  InjectFooter;
  SetFooterVersion('ver - ' + TDMConnection.clientVersion);
  NavScrollSizing;
end;


procedure TFCustomSoftware.NavScrollSizing;
begin
  asm
    window.addEventListener('scroll', function() {
      var navbar = document.querySelector('.em-navbar-wrap .navbar');
      var logo = document.querySelector('.em-brand img');
      var scrollDistance = 50; // Adjust based on your preference

      if (window.scrollY > scrollDistance) {
        navbar.classList.add('scrolled');
        logo.classList.add('scrolled-logo');
      } else {
        navbar.classList.remove('scrolled');
        logo.classList.remove('scrolled-logo');
      }
    });
  end;
end;



initialization
  RegisterClass(TFCustomSoftware);

end. 