unit View.Home;

interface

uses
  System.SysUtils, System.Classes, WEBLib.Graphics, WEBLib.Forms, Vcl.StdCtrls,
  WEBLib.StdCtrls, Vcl.Controls, WEBLib.Dialogs, Vcl.Imaging.pngimage,
  WEBLib.ExtCtrls, WEBLib.Controls, Web, JS, WEBLib.Menus, WEBLib.WebCtrls;

type
  TFHome = class(TWebForm)
    btnRecordsManagementLearn: TWebButton;
    btnCustomSoftwareLearn: TWebButton;
    btnPublicSafetyLearn: TWebButton;
    procedure WebFormShow(Sender: TObject);
    [async]
  private
    { Private declarations }
  public
    procedure NavScrollSizing;
  end;

var
  FHome: TFHome;

implementation

{$R *.dfm}

uses
View.AboutUs,
View.ContactUs,
View.CustomSoftware,
View.PublicSafety,
ConnectionModule,
Site.Footer,
Site.Navbar,
View.RecordsManagement;


procedure TFHome.WebFormShow(Sender: TObject);
begin
  Application.ThemeColor := clTMSWEB;
  InjectNavbar;
  InjectFooter;
  SetFooterVersion('ver - ' + TDMConnection.clientVersion);
  NavScrollSizing;
end;

procedure TFHome.NavScrollSizing;
begin
  asm
    window.addEventListener('scroll', function() {
      var navbar = document.querySelector('.em-navbar-wrap .navbar');
      var logo = document.querySelector('.em-brand img');
      var scrollDistance = 50; // Adjust based on your preference

      if (window.scrollY > scrollDistance) {
        navbar.classList.add('scrolled');
        logo.classList.add('scrolled-logo');
      } else {
        navbar.classList.remove('scrolled');
        logo.classList.remove('scrolled-logo');
      }
    });
  end;
end;


initialization
  RegisterClass(TFHome);

end.             