unit Api.Database;

interface

uses
  System.SysUtils, System.Classes, Data.DB, MemDS, DBAccess, Uni, UniProvider,
  PostgreSQLUniProvider;

type
  TApiDatabase = class(TDataModule)
    ucBooking: TUniConnection;
    PostgreSQLUniProvider1: TPostgreSQLUniProvider;
    UniQuery1: TUniQuery;
  private
    { Private declarations }
  public
    { Public declarations }
    class procedure ExecSQL(const SQL: string);
  end;

var
  ApiDatabase: TApiDatabase;

implementation

{%CLASSGROUP 'Vcl.Controls.TControl'}

{$R *.dfm}

class procedure TApiDatabase.ExecSQL(const SQL: string);
var
  DB: TApiDatabase;
begin
  DB := TApiDatabase.Create(nil);
  try
    DB.UniQuery1.SQL.Text := SQL;
    DB.UniQuery1.ExecSQL;
  finally
    DB.Free;
  end;
end;

end.
