unit View.Home;

interface

uses
  System.SysUtils, System.Classes, WEBLib.Graphics, WEBLib.Forms, Vcl.StdCtrls,
  WEBLib.StdCtrls, Vcl.Controls, WEBLib.Dialogs, Vcl.Imaging.pngimage,
  WEBLib.ExtCtrls, WEBLib.Controls, Web, JS, WEBLib.Menus, WEBLib.WebCtrls;

type
  TFHome = class(TWebForm)
    btnHome: TWebButton;
    btnAboutUs: TWebButton;
    btnContactUs: TWebButton;
    btnCustomSoftware: TWebButton;
    btnRecordsManagementLearn: TWebButton;
    btnCustomSoftwareLearn: TWebButton;
    btnHomeFooter: TWebButton;
    btnContactUsFooter: TWebButton;
    btnAboutUsFooter: TWebButton;
    btnPublicSafetyLearn: TWebButton;
    btnPublicSafety: TWebButton;
    btnRecordsManagement: TWebButton;
    [async]
    procedure WebFormCreate(Sender: TObject);
    procedure btnHomeClick(Sender: TObject);
    procedure btnAboutUsClick(Sender: TObject);
    procedure btnContactUsClick(Sender: TObject);
    procedure btnRecordsManagementClick(Sender: TObject);
    procedure btnCustomSoftwareClick(Sender: TObject);
    procedure btnPublicSafetyClick(Sender: TObject);
    procedure WebFormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    procedure NavScrollSizing;
  end;

var
  FHome: TFHome;

implementation

{$R *.dfm}

uses
View.AboutUs,
View.ContactUs,
View.CustomSoftware,
View.PublicSafety,
View.RecordsManagement;

//Navbar
procedure TFHome.btnCustomSoftwareClick(Sender: TObject);
begin
  Close;
  Application.CreateForm(TFCustomSoftware, FCustomSoftware);
end;

procedure TFHome.btnRecordsManagementClick(Sender: TObject);
begin
  Close;
  Application.CreateForm(TFRecordsManagement, FRecordsManagement); 
end;

procedure TFHome.btnPublicSafetyClick(Sender: TObject);
begin
  Close;
  Application.CreateForm(TFPublicSafety, FPublicSafety);  
end;

procedure TFHome.btnContactUsClick(Sender: TObject);
begin
  Close;
  Application.CreateForm(TFContactUs, FContactUs);  
end;

procedure TFHome.btnAboutUsClick(Sender: TObject);
begin
  Close;
  Application.CreateForm(TFAboutUs, FAboutUs);  
end;

procedure TFHome.btnHomeClick(Sender: TObject);
begin
  Close;
  Application.CreateForm(TFHome, FHome);  
end;

procedure TFHome.WebFormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TFHome.WebFormCreate(Sender: TObject);
begin
  Application.ThemeColor := clTMSWEB;
  NavScrollSizing;
end;

procedure TFHome.NavScrollSizing;
begin
  asm
    window.addEventListener('scroll', function() {
      var navbar = document.querySelector('.em-navbar-wrap .navbar');
      var logo = document.querySelector('.em-brand img');
      var scrollDistance = 50; // Adjust based on your preference

      if (window.scrollY > scrollDistance) {
        navbar.classList.add('scrolled');
        logo.classList.add('scrolled-logo');
      } else {
        navbar.classList.remove('scrolled');
        logo.classList.remove('scrolled-logo');
      }
    });
  end;
end;

initialization
  RegisterClass(TFHome);

end.             