unit View.PublicSafety;

interface

uses
  System.SysUtils, System.Classes, WEBLib.Graphics, WEBLib.Forms, Vcl.StdCtrls,
  WEBLib.StdCtrls, Vcl.Controls, WEBLib.Dialogs, Vcl.Imaging.pngimage,
  WEBLib.ExtCtrls, WEBLib.Controls, Web, JS, WEBLib.Menus, WEBLib.WebCtrls;

type
  TFPublicSafety = class(TWebForm)
    procedure WebFormShow(Sender: TObject);
    [async]
  private
    { Private declarations }
  public
    procedure NavScrollSizing;
  end;

var
  FPublicSafety: TFPublicSafety;

implementation

{$R *.dfm}

uses
View.AboutUs,
View.ContactUs,
View.CustomSoftware,
View.Home,
Site.Navbar,
Site.Footer,
ConnectionModule,
View.RecordsManagement;


procedure TFPublicSafety.WebFormShow(Sender: TObject);
begin
  Application.ThemeColor := clTMSWEB;
  InjectNavbar;
  InjectFooter;
  SetFooterVersion('ver - ' + TDMConnection.clientVersion);
  NavScrollSizing;
end;


procedure TFPublicSafety.NavScrollSizing;
begin
  asm
    window.addEventListener('scroll', function() {
      var navbar = document.querySelector('.em-navbar-wrap .navbar');
      var logo = document.querySelector('.em-brand img');
      var scrollDistance = 50; // Adjust based on your preference

      if (window.scrollY > scrollDistance) {
        navbar.classList.add('scrolled');
        logo.classList.add('scrolled-logo');
      } else {
        navbar.classList.remove('scrolled');
        logo.classList.remove('scrolled-logo');
      }
    });
  end;
end;



initialization
  RegisterClass(TFPublicSafety);

end.  