unit View.RecordsManagement;

interface

uses
  System.SysUtils, System.Classes, WEBLib.Graphics, WEBLib.Forms, Vcl.StdCtrls,
  WEBLib.StdCtrls, Vcl.Controls, WEBLib.Dialogs, Vcl.Imaging.pngimage,
  WEBLib.ExtCtrls, WEBLib.Controls, Web, JS, WEBLib.Menus, WEBLib.WebCtrls;

type
  TFRecordsManagement = class(TWebForm)
    [async]
    procedure WebFormShow(Sender: TObject);
  private
    { Private declarations }
  public
    procedure NavScrollSizing;
  end;

var
  FRecordsManagement: TFRecordsManagement;

implementation

{$R *.dfm}

uses
View.AboutUs,
View.ContactUs,
View.CustomSoftware,
View.PublicSafety,
Site.Navbar,
Site.Footer,
ConnectionModule,
View.Home;

procedure TFRecordsManagement.WebFormShow(Sender: TObject);
begin
  Application.ThemeColor := clTMSWEB;
  InjectNavbar;
  InjectFooter;
  SetFooterVersion('ver - ' + TDMConnection.clientVersion);
  NavScrollSizing;
end;

procedure TFRecordsManagement.NavScrollSizing;
begin
  asm
    window.addEventListener('scroll', function() {
      var navbar = document.querySelector('.em-navbar-wrap .navbar');
      var logo = document.querySelector('.em-brand img');
      var scrollDistance = 50; // Adjust based on your preference

      if (window.scrollY > scrollDistance) {
        navbar.classList.add('scrolled');
        logo.classList.add('scrolled-logo');
      } else {
        navbar.classList.remove('scrolled');
        logo.classList.remove('scrolled-logo');
      }
    });
  end;
end;

initialization
  RegisterClass(TFRecordsManagement);

end.