unit Api.Server.Module;

interface

uses
  System.SysUtils, System.Classes, System.IniFiles,
  Sparkle.HttpServer.Module, Sparkle.HttpServer.Context,
  Sparkle.Comp.Server, Sparkle.Comp.HttpSysDispatcher,
  XData.Comp.Server, XData.Comp.ConnectionPool,
  Sparkle.Comp.GenericMiddleware, Sparkle.Comp.JwtMiddleware,
  Sparkle.Comp.BasicAuthMiddleware, Sparkle.Comp.CorsMiddleware,
  Sparkle.Comp.CompressMiddleware, VCL.Forms, XData.Server.Module, Common.Logging;

type
  TApiServerModule = class(TDataModule)
    SparkleHttpSysDispatcher: TSparkleHttpSysDispatcher;
    XDataServer: TXDataServer;
    XDataServerCompress: TSparkleCompressMiddleware;
    XDataServerCORS: TSparkleCorsMiddleware;
  public
    procedure StartApiServer(ABaseUrl: string);
  end;

var
  ApiServerModule: TApiServerModule;

implementation

{%CLASSGROUP 'Vcl.Controls.TControl'}

{$R *.dfm}


procedure TApiServerModule.StartApiServer(ABaseUrl: string);
begin
  Logger.Log(1, '--- StartApiServer: Initializing ---');

  XDataServer.BaseUrl := ABaseUrl;

  try
    SparkleHttpSysDispatcher.Start;
    Logger.Log(1, 'XData Server started at: ' + XDataServer.BaseUrl);
  except
    on E: Exception do
    begin
      Logger.Log(5, 'Failed to start XData server: ' + E.Message);
      raise;
    end;
  end;

  Logger.Log(1, '--- StartApiServer: Complete ---');
end;





end.
