// The configuartion file for the program. Contains important info like the admin
// password and the secret token. Should likely move this to the ini file..

unit Common.Config;

interface

const
  defaultServerUrl = 'http://localhost:2002/website/';

type
  TServerConfig = class
  private
    Furl: string;
    FJWTTokenSecret: string;
    FAdminPassword: string;
    FWebAppFolder: string;
    FMemoLogLevel: Integer;
    FFileLogLevel: Integer;
  public
    constructor Create;
    property url: string read FUrl write FUrl;
    property jwtTokenSecret: string read FJWTTokenSecret write FJWTTokenSecret;
    property adminPassword: string read FAdminPassword write FAdminPassword;
    property webAppFolder: string read FWebAppFolder write FWebAppFolder;
  end;

procedure LoadServerConfig;

var
  serverConfig: TServerConfig;

implementation

uses
  Bcl.Json, System.SysUtils, System.IOUtils,
  Common.Logging;

procedure LoadServerConfig;
var
  configFile: string;
  localConfig: TServerConfig;
begin
  Logger.Log( 1, '--LoadServerConfig - start' );
  configFile := 'serverconfig.json';
  Logger.Log( 1, '-- Config file: ' + ConfigFile );
  if TFile.Exists(ConfigFile) then
  begin
    Logger.Log( 1, '-- Config file found.' );
    localConfig := TJson.Deserialize<TServerConfig>(TFile.ReadAllText(configFile));
    Logger.Log( 1, '-- localConfig loaded from config file' );
    serverConfig.Free;
    Logger.Log( 1, '-- serverConfig.Free - called' );
    serverConfig := localConfig;
    Logger.Log( 1, '-- serverConfig := localConfig - called' );
  end
  else
  begin
    Logger.Log( 1, '-- Config file not found.' );
  end;
  Logger.Log( 1, '-------------------------------------------------------------' );
  Logger.Log( 1, '-- serverConfig.Server url: ' + serverConfig.url );
  Logger.Log( 1, '-- serverConfig.adminPassword: ' + serverConfig.adminPassword );
  Logger.Log( 1, '-- serverConfig.jwtTokenSecret: ' + serverConfig.jwtTokenSecret );
  Logger.Log( 1, '-- serverConfig.webAppFolder: ' + serverConfig.webAppFolder );
  Logger.Log( 1, '--LoadServerConfig - end' );
end;

{ TServerConfig }

constructor TServerConfig.Create;
//var
//  ConfigFile: string;
//  ServerConfigStr: string;
begin
  Logger.Log( 1, '--TServerConfig.Create - start' );
  url := defaultServerUrl;
  adminPassword := 'whatisthisusedfor';
  jwtTokenSecret := 'super_secret0123super_secret4567';
  webAppFolder := 'static';
//  ServerConfigStr := Bcl.Json.TJson.Serialize( ServerConfig );
//  ConfigFile := 'serverconfig.json';
//  TFile.WriteAllText( ConfigFile, ServerConfigStr );
//  Logger.Log( 1, 'ServerConfig saved to file: ' + ConfigFile );
  Logger.Log( 1, '--TServerConfig.Create - end' );
end;


end.
