unit View.RecordsManagement;

interface

uses
  System.SysUtils, System.Classes, WEBLib.Graphics, WEBLib.Forms, Vcl.StdCtrls,
  WEBLib.StdCtrls, Vcl.Controls, WEBLib.Dialogs, Vcl.Imaging.pngimage,
  WEBLib.ExtCtrls, WEBLib.Controls, Web, JS, WEBLib.Menus, WEBLib.WebCtrls;

type
  TFRecordsManagement = class(TWebForm)
    btnHome: TWebButton;
    btnAboutUs: TWebButton;
    btnContactUs: TWebButton;
    btnRecordsManagement: TWebButton;
    btnCustomSoftware: TWebButton;
      btnContactUsFooter: TWebButton;
      btnHomeFooter: TWebButton;
      btnAboutUsFooter: TWebButton;
    btnPublicSafety: TWebButton;

    procedure btnHomeClick(Sender: TObject);
    procedure btnAboutUsClick(Sender: TObject);
    procedure btnContactUsClick(Sender: TObject);
    procedure btnRecordsManagementClick(Sender: TObject);
    procedure btnCustomSoftwareClick(Sender: TObject);
    procedure btnPublicSafetyClick(Sender: TObject);
    [async]
    procedure WebFormCreate(Sender: TObject);
    procedure WebFormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    procedure NavScrollSizing;
  end;

var
  FRecordsManagement: TFRecordsManagement;

implementation

{$R *.dfm}

uses
View.AboutUs,
View.ContactUs,
View.CustomSoftware,
View.PublicSafety,
View.Home;


procedure TFRecordsManagement.btnCustomSoftwareClick(Sender: TObject);
begin
  Close;
  Application.CreateForm(TFCustomSoftware, FCustomSoftware);
end;

procedure TFRecordsManagement.btnRecordsManagementClick(Sender: TObject);
begin
  Close;
  Application.CreateForm(TFRecordsManagement, FRecordsManagement); 
end;

procedure TFRecordsManagement.btnPublicSafetyClick(Sender: TObject);
begin
  Close;
  Application.CreateForm(TFPublicSafety, FPublicSafety);  
end;

procedure TFRecordsManagement.btnContactUsClick(Sender: TObject);
begin
  Close;
  Application.CreateForm(TFContactUs, FContactUs);  
end;

procedure TFRecordsManagement.btnAboutUsClick(Sender: TObject);
begin
  Close;
  Application.CreateForm(TFAboutUs, FAboutUs);  
end;

procedure TFRecordsManagement.btnHomeClick(Sender: TObject);
begin
  Close;
  Application.CreateForm(TFHome, FHome);  
end;

procedure TFRecordsManagement.WebFormCreate(Sender: TObject);
begin
  Application.ThemeColor := clTMSWEB;
  NavScrollSizing;
end;

procedure TFRecordsManagement.NavScrollSizing;
begin
  asm
    window.addEventListener('scroll', function() {
      var navbar = document.querySelector('.em-navbar-wrap .navbar');
      var logo = document.querySelector('.em-brand img');
      var scrollDistance = 50; // Adjust based on your preference

      if (window.scrollY > scrollDistance) {
        navbar.classList.add('scrolled');
        logo.classList.add('scrolled-logo');
      } else {
        navbar.classList.remove('scrolled');
        logo.classList.remove('scrolled-logo');
      }
    });
  end;
end;

procedure TFRecordsManagement.WebFormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

initialization
  RegisterClass(TFRecordsManagement);

end.   