unit Utils;

interface

uses
  System.Classes, SysUtils, JS, Web, WEBLib.Forms;

procedure ShowStatusMessage(const AMessage, AClass: string; const AElementId: string);
procedure HideStatusMessage(const AElementId: string);
procedure ShowSpinner(SpinnerID: string);
procedure HideSpinner(SpinnerID: string);
procedure ShowNotificationModal(msg: string);


implementation

procedure ShowStatusMessage(const AMessage, AClass: string; const AElementId: string);
var
  StatusMessage: TJSHTMLElement;
begin
  StatusMessage := TJSHTMLElement(document.getElementById(AElementId));
  if Assigned(StatusMessage) then
  begin
    if AMessage = '' then
    begin
      StatusMessage.style.setProperty('display', 'none');
      StatusMessage.className := '';
      StatusMessage.innerHTML := '';
    end
    else
    begin
      StatusMessage.innerHTML := AMessage;
      StatusMessage.className := 'alert ' + AClass;
      StatusMessage.style.setProperty('display', 'block');
    end
  end
  else
    console.log('Error: Status message element not found');
end;


procedure HideStatusMessage(const AElementId: string);
var
  StatusMessage: TJSHTMLElement;
begin
  StatusMessage := TJSHTMLElement(document.getElementById(AElementId));
  if Assigned(StatusMessage) then
  begin
    StatusMessage.style.setProperty('display', 'none');
    StatusMessage.className := '';
    StatusMessage.innerHTML := '';
  end
  else
    console.log('Error: Status message element not found');
end;


procedure ShowSpinner(SpinnerID: string);
var
  SpinnerElement: TJSHTMLElement;
begin
  SpinnerElement := TJSHTMLElement(document.getElementById(SpinnerID));
  if Assigned(SpinnerElement) then
  begin
    // Move spinner to the <body> if it's not already there
    asm
      if (SpinnerElement.parentNode !== document.body) {
        document.body.appendChild(SpinnerElement);
      }
    end;

    SpinnerElement.classList.remove('d-none');
    SpinnerElement.classList.add('d-block');
  end;
end;

procedure HideSpinner(SpinnerID: string);
var
  SpinnerElement: TJSHTMLElement;
begin
  SpinnerElement := TJSHTMLElement(document.getElementById(SpinnerID));
  if Assigned(SpinnerElement) then
  begin
    SpinnerElement.classList.remove('d-block');
    SpinnerElement.classList.add('d-none');
  end;
end;


procedure ShowNotificationModal(msg: string);
begin
  asm
    var modal = document.getElementById('contact_notification_modal');
    var label = document.getElementById('contact_notification_modal_body');
    var closeBtn = document.getElementById('btn_modal_close');

    if (label) label.innerText = msg;

    // Ensure modal is a direct child of <body>
    if (modal && modal.parentNode !== document.body) {
      document.body.appendChild(modal);
    }

    // Button simply closes the modal
    if (closeBtn) {
      closeBtn.onclick = function () {
        var existing = bootstrap.Modal.getInstance(modal);
        if (existing) {
          existing.hide();
        }
      };
    }

    // Show the Bootstrap modal
    var bsModal = new bootstrap.Modal(modal, { keyboard: false });
    bsModal.show();
  end;
end;

end.
