unit View.RequestDemo;

interface

uses
  System.SysUtils, System.Classes, JS, Web, WEBLib.Graphics, WEBLib.Controls,
  WEBLib.Forms, WEBLib.Dialogs, Vcl.StdCtrls, WEBLib.StdCtrls, Vcl.Controls,
  XData.Web.Client, ConnectionModule, Utils, WEBLib.RegularExpressions;

type
  TFRequestDemo = class(TWebForm)
    edtReqName: TWebEdit;
    edtReqEmail: TWebEdit;
    edtReqAgency: TWebEdit;
    edtReqPhoneNumber: TWebEdit;
    lblReqPrefMethod: TWebLabel;
    radReqPhone: TWebRadioButton;
    radReqEmail: TWebRadioButton;
    btnReqSendRequest: TWebButton;
    xdwcRequestDemo: TXDataWebClient;
    edtReqState: TWebEdit;
    edtReqCounty: TWebEdit;
    memoAdditionalComments: TWebMemo;
    wcbInterest: TWebComboBox;
    procedure btnReqSendRequestClick(Sender: TObject);
    procedure radReqEmailClick(Sender: TObject);
    procedure radReqPhoneClick(Sender: TObject);
    procedure WebFormCreate(Sender: TObject);
    procedure xdwcRequestDemoError(Error: TXDataClientError);
  private
    function IsEmailValid(const email: string): Boolean;
    function PreferredMethod: string;
    procedure NavScrollSizing;
    procedure ClearFieldErrors;
    procedure SetInvalid(const inputId: string);
    function ValidateRequest: Boolean;
    procedure SendRequest;
  end;

var
  FRequestDemo: TFRequestDemo;

implementation

{$R *.dfm}

uses
  Site.Navbar,
  Site.Footer;

procedure TFRequestDemo.WebFormCreate(Sender: TObject);
begin
  Application.ThemeColor := clTMSWEB;
  InjectNavbar;
  InjectFooter;
  SetFooterVersion('ver - ' + TDMConnection.clientVersion);
  NavScrollSizing;
end;

procedure TFRequestDemo.xdwcRequestDemoError(Error: TXDataClientError);
begin
  Utils.HideSpinner('spinner');
  ShowNotificationModal('Error when attempting to send: ' + Error.ErrorMessage);
end;

procedure TFRequestDemo.NavScrollSizing;
begin
  asm
    window.addEventListener('scroll', function() {
      var navbar = document.querySelector('.em-navbar-wrap .navbar');
      var logo = document.querySelector('.em-brand img');
      var scrollDistance = 50;

      if (window.scrollY > scrollDistance) {
        navbar.classList.add('scrolled');
        logo.classList.add('scrolled-logo');
      } else {
        navbar.classList.remove('scrolled');
        logo.classList.remove('scrolled-logo');
      }
    });
  end;
end;

function TFRequestDemo.IsEmailValid(const email: string): Boolean;
const
  pattern = '^[^\s@]+@[^\s@]+\.[^\s@]+$';
begin
  Result := TRegEx.IsMatch(email.Trim, pattern);
end;

function TFRequestDemo.PreferredMethod: string;
begin
  if radReqPhone.Checked then
    Exit('phone');
  if radReqEmail.Checked then
    Exit('email');
  Result := '';
end;


procedure TFRequestDemo.SetInvalid(const inputId: string);
var
  inputEl: TJSHTMLElement;
begin
  inputEl := TJSHTMLElement(document.getElementById(inputId));
  if Assigned(inputEl) then
    inputEl.classList.add('is-invalid');
end;

procedure TFRequestDemo.ClearFieldErrors;
var
  inputEl: TJSHTMLElement;
begin
  inputEl := TJSHTMLElement(document.getElementById('edt_req_name'));
  if Assigned(inputEl) then inputEl.classList.remove('is-invalid');

  inputEl := TJSHTMLElement(document.getElementById('edt_req_email'));
  if Assigned(inputEl) then inputEl.classList.remove('is-invalid');

  inputEl := TJSHTMLElement(document.getElementById('edt_req_phone_number'));
  if Assigned(inputEl) then inputEl.classList.remove('is-invalid');

  inputEl := TJSHTMLElement(document.getElementById('edt_req_agency'));
  if Assigned(inputEl) then inputEl.classList.remove('is-invalid');
end;

function TFRequestDemo.ValidateRequest: Boolean;
var
  isValid: Boolean;
  emailText: string;
begin
  ClearFieldErrors;
  isValid := True;

  if edtReqName.Text.Trim = '' then
  begin
    SetInvalid('edt_req_name');
    isValid := False;
  end;

  emailText := edtReqEmail.Text.Trim;
  if emailText = '' then
  begin
    SetInvalid('edt_req_email');
    isValid := False;
  end
  else if not IsEmailValid(emailText) then
  begin
    SetInvalid('edt_req_email');
    isValid := False;
  end;

  if edtReqPhoneNumber.Text.Trim = '' then
  begin
    SetInvalid('edt_req_phone_number');
    isValid := False;
  end;

  if edtReqAgency.Text.Trim = '' then
  begin
    SetInvalid('edt_req_agency');
    isValid := False;
  end;

  Result := isValid;
end;


procedure TFRequestDemo.btnReqSendRequestClick(Sender: TObject);
begin
  if not ValidateRequest then
    Exit;

  Utils.ShowSpinner('spinner');

  if not DMConnection.ApiConnection.Connected then
  begin
    DMConnection.ApiConnection.Open(
      procedure
      begin
        SendRequest;
      end);
    Exit;
  end;

  SendRequest;
end;

procedure TFRequestDemo.radReqEmailClick(Sender: TObject);
begin
  if radReqEmail.Checked then
  radReqPhone.Checked := False;
end;

procedure TFRequestDemo.radReqPhoneClick(Sender: TObject);
begin
  if radReqPhone.Checked then
  radReqEmail.Checked := False;
end;

procedure TFRequestDemo.SendRequest;
var
  bodyText: string;
  pref: string;
begin
  pref := PreferredMethod;

  bodyText :=
    'Demo request details:' + sLineBreak +
    'Name: ' + edtReqName.Text + sLineBreak +
    'Email: ' + edtReqEmail.Text + sLineBreak +
    'Phone: ' + edtReqPhoneNumber.Text + sLineBreak +
    'Company/Agency: ' + edtReqAgency.Text + sLineBreak +
    'State: ' + edtReqState.Text + sLineBreak +
    'County: ' + edtReqCounty.Text + sLineBreak +
    'Interest: ' + wcbInterest.Text + sLineBreak +
    'Additional comments: ' + memoAdditionalComments.Text;

  if pref <> '' then
    bodyText := bodyText + sLineBreak + 'Preferred contact: ' + pref;

  xdwcRequestDemo.RawInvoke('IApiService.SendEmail',
    [edtReqName.Text, edtReqEmail.Text, 'Demo Request', bodyText],
    procedure(response: TXDataClientResponse)
    begin
      Utils.HideSpinner('spinner');
      ClearFieldErrors;

      edtReqName.Text := '';
      edtReqEmail.Text := '';
      edtReqPhoneNumber.Text := '';
      edtReqAgency.Text := '';
      edtReqState.Text := '';
      edtReqCounty.Text := '';
      memoAdditionalComments.Text := '';
      radReqPhone.Checked := False;
      radReqEmail.Checked := True;
      wcbInterest.ItemIndex := -1;

      ShowNotificationModal('Your demo request has been submitted. Please check your email for confirmation. If you did not recieve an email, reach out directly.');
    end);
end;

initialization
  RegisterClass(TFRequestDemo);

end.

