unit Utils;

interface

uses
  System.Classes, SysUtils, JS, Web, WEBLib.Forms;

procedure ShowStatusMessage(const AMessage, AClass: string; const AElementId: string);
procedure HideStatusMessage(const AElementId: string);
procedure ShowSpinner(SpinnerID: string);
procedure HideSpinner(SpinnerID: string);


implementation

procedure ShowStatusMessage(const AMessage, AClass: string; const AElementId: string);
var
  StatusMessage: TJSHTMLElement;
begin
  StatusMessage := TJSHTMLElement(document.getElementById(AElementId));
  if Assigned(StatusMessage) then
  begin
    if AMessage = '' then
    begin
      StatusMessage.style.setProperty('display', 'none');
      StatusMessage.className := '';
      StatusMessage.innerHTML := '';
    end
    else
    begin
      StatusMessage.innerHTML := AMessage;
      StatusMessage.className := 'alert ' + AClass;
      StatusMessage.style.setProperty('display', 'block');
    end
  end
  else
    console.log('Error: Status message element not found');
end;


procedure HideStatusMessage(const AElementId: string);
var
  StatusMessage: TJSHTMLElement;
begin
  StatusMessage := TJSHTMLElement(document.getElementById(AElementId));
  if Assigned(StatusMessage) then
  begin
    StatusMessage.style.setProperty('display', 'none');
    StatusMessage.className := '';
    StatusMessage.innerHTML := '';
  end
  else
    console.log('Error: Status message element not found');
end;


procedure ShowSpinner(SpinnerID: string);
var
  SpinnerElement: TJSHTMLElement;
begin
  SpinnerElement := TJSHTMLElement(document.getElementById(SpinnerID));
  if Assigned(SpinnerElement) then
  begin
    SpinnerElement.classList.remove('d-none');
    SpinnerElement.classList.add('d-block');
  end;
end;

procedure HideSpinner(SpinnerID: string);
var
  SpinnerElement: TJSHTMLElement;
begin
  SpinnerElement := TJSHTMLElement(document.getElementById(SpinnerID));
  if Assigned(SpinnerElement) then
  begin
    SpinnerElement.classList.remove('d-block');
    SpinnerElement.classList.add('d-none');
  end;
end;

end.
